#include <stdio.h>
#include <stdlib.h>
#include <stddef.h>
#include <time.h>

#define nn 500000002
#define nm nn-2

int pickup_sosuu(int p)
{
  if ((p % 2)==1){
  return (((p/2)+1)*6-1);
  }else{
  return ((p/2)*6+1);
  } 
}
int main(void)
{
    time_t start_time;  /* 開始時間の記録変数 */
    time_t now_time;    /* 現在時間を取り込む変数 */
    FILE *fp;           /* 保存するファイルのポインタ */
    int *s2;         /* 素数表の配列 */
    int n,n1,n2,n3;  /* 素数候補 */
    int k1,k2;          /* 次の候補への増分 */
    int i,i1,i2,max;              /* 素数表を走査するポインタ */
    int j,j1,j2;          /* 素数表に次に登録される素数表の位置ポインタ */
    int l1,l2,l3;    /* 素数表に次に登録される素数表の位置ポインタ */
    int minuts;
    int seconds;

     s2=malloc(sizeof(int)*nn);   /*  素数候補のエラトステネス篩の結果 */

    start_time=time(NULL);
    /* 保存はカレントディレクトリーのsosuuhyoというファイル名で上書きする */
    if((fp=fopen("souuhyo","w"))== NULL){
        printf("cannot open souuhyo\n");
        exit(1);
    }

/* 素数表を初期化しておく */
    i=1;
    for (n=1;n<(nn/2);n++)
      {       
       s2[i]=6*n-1;       
       i=i+1; 
       s2[i]=6*n+1; 
       i=i+1;
    }
    max=i;
    k1=1;
  do
  {  
    k2=1;
    /* エラトステネスの篩 */
    j1=pickup_sosuu(k1); /* 表から基本素数候補をピックアップ */
    j2=pickup_sosuu(k2);k2++; /* 表から積数素数候補をピックアップ */

    /* n1に初項の順位の取り出し */
    l1=j1*j2;       /* 初項の積 */
    n1=l1 % 6;
    if (n1==5) {      /* 積が6n-1か */
       n1=(l1/6+1)*2-1;/* 積が6n-1 なので n1=2n-1 */
    }else{
       n1=(l1/6)*2;/* 積が6n+1 なので n1=2n */
    }
          
    /* n2に次項の順位の取り出し */
    j2=pickup_sosuu(k2);k2++; /* 次項の取り出し*/
    l2=j1*j2;       /* 次項の積 */
    n2=l2 % 6;
    if (n2==5) {      /* 積が6n-1か */
       n2=(l2/6+1)*2-1;/* 積が6n-1 なので n2=2n-1 */
    }else{
       n2=(l2/6)*2;/* 積が6n+1 なので n2=2n */
    }
    
    /* n3に次項の順位の取り出し */
    j2=pickup_sosuu(k2);k2++;  /* 第三項の取り出し*/
    l3=j1*j2;        /* 第三項の積 */
    n3=l3 % 6;
    if (n3==5) {      /* 積が6n-1か  */
       n3=(l3/6+1)*2-1;/* 積が6n-1 なので n3=2n-1 */
    }else{
       n3=(l3/6)*2;/* 積が6n+1 なので n2=2n */
    }
    
    i1=n2-n1;      /* 増分２  */   
    i2=n3-n2;
    
    /* いっきに表から削除*/
     s2[n1]=0;
     i=n1;

    do
    {
     i=i+i1;
     if (i > max-1) break;
     s2[i]=0;
     i=i+i2;
     if (i > max-1) break;
     s2[i]=0;
    }
    while (i < max+i1+i2);
   now_time=time(NULL);  /* 現在時間の取得 */
   /* 以下の3行のコメントを外すと途中結果を表示する。*/
   //   minuts=(now_time-start_time)/60;
   //   seconds=(now_time-start_time) % 60;
   //   printf("篩=%d 経過時間= %d 分 %d 秒 \n",pickup_sosuu(k1),minuts,seconds);
   if (pickup_sosuu(max-1)<pickup_sosuu(k1)*pickup_sosuu(k1)) break;
   k1++;
  }
  while (k1< max);
  


/* 完了時間の表示 */
    now_time=time(NULL);  /* 現在時間の取得 */
    minuts=(now_time-start_time)/60;
    seconds=(now_time-start_time) % 60;
    printf("篩=%d 経過時間= %d 分 %d 秒 \n",pickup_sosuu(k1),minuts,seconds);
/*打ち出し*/
    printf("now saving  disk file!");
    j=0;
    fprintf(fp,"2\t3\t");j++;j++;
    for (i=0;i<max;i++)
    {   /* ８個ごとに改行する */
        if (s2[i] != 0){
          if((j % 8  == 0)&&(0<j)){fprintf(fp,("\n"));}
          fprintf(fp,"%d\t",s2[i]);
          j++;
        }  
    }
   printf("素数個数=%d \n",j);
//*終わり*
    free(s2);
    fprintf(fp,("\n"));
    fclose(fp);
    return(0);
}












