#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
/*     制御定数宣言                    */
#define nn 9699690             /*                           */
#define mm 10000000            /*                           */
//#define debug 1
/*     文字宣言                      */
const char c='%';             /*                           */
const char slash=0x5c;        /*                           */
const char dash=0x22;         /*                           */
/*     型宣言変数                      */
enum bool {false,true} flag,flag3,flag5,flag7,flag11,flag13,flag17,flag19; /*          */
/*     素因数分解表示文字列                      */
char factor[]={"                                                   "};/* 素因数分解結果 */ 
char file_name[]={"Sophie-Germain_2000.tex"};

int main (int argc,char *argv[])
{
/*   使用変数宣言         */
    FILE *fpr;           /* 素数表ファイルのポインタ      */
    FILE *fpw[2000];           /* 出力texファイルのポインタ 　　　  */
    FILE *rp;            /* Qhyoのポインタ 　　　         */
    int *s1;             /* 素数表                       */
    int *s2;             /* P表　                        */
    int i;               /* カウンタ変数                  */
    int j;               /* 素数表アクセスインデックス     */
    int k;               /* P値計算変数                   */
    int k_start;         /* 2A+1のP値                     */
    int k_end;           /* P値素因数分解 */
    int maxi;            /* P表のPの数 */
    int maxfpr;          /* 素数表の素数の数 */
    int total_file_count; /* tex fileの数 */
    int tfc=0;              /* tex fileの番号 */
    /*  素数表を読み込み用のバッファの確保 */
    if(NULL==(s1=(int *)malloc(sizeof(int)*nn))){   /*  素数表の領域 */
      printf("素数表の領域が確保できませんでした\n");
      exit (1);
    }

    /*  P表を読み込み用のバッファの確保 */
    if(NULL==(s2=(int *)malloc(sizeof(int)*nn))){   /*  P表の領域 */
      printf("P表の領域が確保できませんでした\n");
      exit (1);
    }

    /* 9699690n+PのPを読み込む */
    if(NULL==(rp=fopen("Qhyo.csv","r"))){
        printf("cannot open Qhyo.csv\n");
        exit(1);
    }
   i=0;
     while(EOF!=fscanf(rp,"%d\t",&s2[i++]));
   fclose(rp);
   printf("Qhyo read!  %d 個 \n",i-1);
   maxi=i-1;
    
    /* sosuuhyoというファイルをfprに読み込む */
    /* ファイルのオープン　*/
   if(NULL==(fpr=fopen("sosuuhyo.csv","r"))){
    /* ファイルのオープン失敗　*/
        printf("cannot open sosuuhyo.csv\n"); 
        exit(1);
    }
    /* 素数表の読み込み　*/
   i=0; 
   while(EOF!=(fscanf(fpr,"%d\t",&s1[i++])));
   fclose(fpr);
   printf("sosuuhyo read!  %d 個 \n",i-1);
   maxfpr=i-1;

/* tex ファイル数の計算  */
     total_file_count=maxi/1024;
     
     for(tfc=0;tfc<total_file_count;tfc++){
     sprintf(file_name,"Sophie-Germain_6_%d.tex",tfc+1);
    /* Sophie-Germain_xx.texというファイルをfpw[tfc]に書き込む */
    /* ファイルのオープン　*/
   if(NULL==(fpw[tfc]=fopen(file_name,"w"))){
    /* ファイルのオープン失敗　*/
        printf("cannot open Sophie-Germain_6_%d.tex\n",tfc); 
        exit(1);
    }
     fprintf(fpw[tfc],"%cdocumentclass[a4j,11pt]{jsarticle}\n",slash);
     fprintf(fpw[tfc],"%cusepackage{amsmath,amssymb}\n",slash);
     fprintf(fpw[tfc],"%cbegin{document}\n",slash);
     fprintf(fpw[tfc],"\n");
     fprintf(fpw[tfc],"%ctitle{ソフィー・ジェルマン素数について%c\n",slash,slash);
     fprintf(fpw[tfc],"($2,3,5,7,11,13,17,19$を除いた素数候補式)}\n");
     fprintf(fpw[tfc],"%cauthor{愛犬ベルのために}\n",slash);
     fprintf(fpw[tfc],"%cdate{最新2017年12月8日}\n",slash);
     fprintf(fpw[tfc],"%cmaketitle\n",slash);
     fprintf(fpw[tfc],"%csection*{更新履歴}\n",slash);
     fprintf(fpw[tfc],"初版2017年12月8日%c%c\n",slash,slash);
     fprintf(fpw[tfc],"%csection*{$2,3,5,7,11,13,17,19$を除いた素数候補式}\n",slash);
     fprintf(fpw[tfc],"$2,3,5,7,11,13,17,19$を除いた素数候補式は、$9699690n+Q$です。\n");

    for(i=tfc*1024+0;i<tfc*1024+1024;i++){
     /* 素因数分解  */
     flag=false;
    
     k_start=s2[i]*2+1;
     k=k_start;
     k_end=1;
       flag3=flag5=flag7=flag11=flag13=flag17=flag19=true;
#ifdef debug
         printf("k=%d \n",k);
#endif
         sprintf(factor," ");
     for (j=0;s1[j]<=k;){ /* s1[j] 素数表からピックアップした素数　*/
#ifdef debug
         printf("k=%d \n",k);
#endif
       if( (k % s1[j])==0 ){ /* kが素数で割れた時*/
         switch (s1[j])      /* 素数が3,5,7,11,13,17,19であるとき*/
         {
            case 3 :
             {
              if (flag3==true){
               flag3=false; 
               k_end*=3;
               };
               break;
             };
            case 5 :
             {
              if (flag5==true){
               flag5=false; 
               k_end*=5;
              };
               break;
             };
            case 7 :
             {
              if (flag7==true){
               flag7=false; 
               k_end*=7;
              };
               break;
             };
            case 11 :
             {
              if (flag11==true){
               flag11=false; 
               k_end*=11;
               };
               break;
             };
            case 13 :
             {
              if (flag13==true){
               flag13=false; 
               k_end*=13;
              };
               break;
             };
            case 17 :
             {
              if (flag17==true){
               flag17=false; 
               k_end*=17;
             };
               break;
             };
            case 19 :
             {
              if (flag19==true){
               flag19=false; 
               k_end*=19;
             };
               break;
             };
         }; 
         k=k/s1[j]; 
         if (flag==false){
         sprintf(factor,"%d",s1[j] ); 
         }else{
         sprintf(factor,"%s%ctimes%d",factor,slash,s1[j] );
         }
#ifdef debug
         printf("k=%d s1[%d]=%d k_end=%d factor=%s \n",k,j,s1[j],k_end,factor);
#endif
         flag=true;
       }else{ 
       j++;
      };
    };
    if (k_end==1)  {
     /*  2,3,5,7,11,13,17,19を因数として持たない時       */
       fprintf(fpw[tfc],"\n");
       fprintf(fpw[tfc],"\n");
     fprintf(fpw[tfc],"$Q=%d$ならば、\n",s2[i]);
     fprintf(fpw[tfc],"%c[P=9699690n+%d %c]\n",slash,s2[i],slash);
     fprintf(fpw[tfc],"%c[2P+1=2(9699690n+%d)+1=19399380n+%d+1=19399380n+%d %c]\n",slash,s2[i],s2[i]*2,s2[i]*2+1,slash);
       fprintf(fpw[tfc],"ところで、19399380は2は2個、3,5,7,11,13,17,19は因数として1個もちますが\n");
       fprintf(fpw[tfc],"%c[%d=%s %ctimes 1  %c] ですから19399380と共通の因数を持ちません。\n",slash,k_start,factor,slash,slash);
     fprintf(fpw[tfc],"%c[2P+1=9699690m+%d %c]\n",slash,s2[i]*2+1,slash);
       fprintf(fpw[tfc],"となりますから、ソフィー・ジェルマン素数になる可能性があります。\n");
     } else {
     /*  2,3,5,7,11,13,17,19を因数として持つ時             */
       fprintf(fpw[tfc],"\n");
       fprintf(fpw[tfc],"\n");
     fprintf(fpw[tfc],"$Q=%d$ならば、\n",s2[i]);
     fprintf(fpw[tfc],"%c[P=9699690n+%d %c]\n",slash,s2[i],slash);
     fprintf(fpw[tfc],"%c[2P+1=2(9699690n+%d)+1=19399380n+%d+1=19399380n+%d %c]\n",slash,s2[i],s2[i]*2,s2[i]*2+1,slash);
       fprintf(fpw[tfc],"ところで、19399380は2は2個、3,5,7,11,13,17,19は因数として1個もちますから\n");
       fprintf(fpw[tfc],"%c[%d=%s %ctimes 1 %c] ですから\n",slash,k_start,factor,slash,slash);
       fprintf(fpw[tfc],"%c[2P+1=%d(%dn+%d) %c]\n",slash,k_end,19399380/k_end,k_start/k_end,slash);
       fprintf(fpw[tfc],"となりますから、$%d$の倍数になり、素数にはなりませんのでソフィー・ジェルマン素数にはなりません。\n",k_end);
     }
   }
     fprintf(fpw[tfc],"%cend{document}\n",slash);

   fclose(fpw[tfc]);
  }
return (EXIT_SUCCESS);
}
